/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.util.impl;

import com.ibm.hwmca.fw.servlet.util.impl.LogOutputWindow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

class CustomizeDialog {
    JFrame window;
    LogOutputWindow logOutputWindow;
    Color[] colors;
    boolean[] enabled;
    JDialog dialog;
    JButton okButton;
    JButton cancelButton;
    JButton editButton;
    JButton defaultButton;
    JButton resetButton;
    JTable table;
    Listener listener;
    public Color[] colorsResult;
    public boolean[] enabledResult;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;

    CustomizeDialog(JFrame window, LogOutputWindow logOutputWindow, Color[] colors, boolean[] enabled) {
        this.window = window;
        this.logOutputWindow = logOutputWindow;
        this.colors = new Color[colors.length];
        System.arraycopy(colors, 0, this.colors, 0, colors.length);
        this.enabled = new boolean[enabled.length];
        System.arraycopy(enabled, 0, this.enabled, 0, enabled.length);
        this.listener = new Listener();
        this.dialog = new JDialog(window, "Customize Log Display Colors", true);
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(this.listener);
        JLabel l = new JLabel("Customize the color to be used for each logger severity level:");
        l.setBorder(BorderFactory.createEmptyBorder(3, 0, 5, 3));
        this.dialog.getContentPane().add((Component)l, "North");
        this.table = new JTable(this.listener);
        this.table.getColumnModel().getColumn(2).setCellRenderer(new CustomTableCellRenderer());
        this.table.getColumnModel().getColumn(2).setPreferredWidth(200);
        this.table.getSelectionModel().addListSelectionListener(this.listener);
        this.table.addMouseListener(this.listener);
        Dimension size = this.table.getPreferredSize();
        size.height = this.table.getRowCount() * (this.table.getRowHeight() + this.table.getRowMargin());
        this.table.setPreferredScrollableViewportSize(size);
        JScrollPane pane = new JScrollPane(this.table);
        this.dialog.getContentPane().add((Component)pane, "Center");
        JPanel buttonPanel = new JPanel();
        this.okButton = new JButton("OK");
        this.okButton.setMnemonic(75);
        this.okButton.addActionListener(this.listener);
        buttonPanel.add(this.okButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setMnemonic(67);
        this.cancelButton.addActionListener(this.listener);
        buttonPanel.add(this.cancelButton);
        this.editButton = new JButton("Edit");
        this.editButton.setMnemonic(69);
        this.editButton.setToolTipText("Edit the color for the selected row");
        this.editButton.addActionListener(this.listener);
        buttonPanel.add(this.editButton);
        this.defaultButton = new JButton("Default");
        this.defaultButton.setMnemonic(68);
        this.defaultButton.setToolTipText("Change the color for the selected row to the default");
        this.defaultButton.addActionListener(this.listener);
        buttonPanel.add(this.defaultButton);
        this.resetButton = new JButton("Reset");
        this.resetButton.setMnemonic(82);
        this.resetButton.setToolTipText("Reset all colors and enablement to their default values");
        this.resetButton.addActionListener(this.listener);
        buttonPanel.add(this.resetButton);
        this.dialog.getContentPane().add((Component)buttonPanel, "South");
        this.enableControls();
        this.dialog.getRootPane().setDefaultButton(this.okButton);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(window);
        this.dialog.show();
    }

    private void enableControls() {
        boolean rowSelected = this.table.getSelectedRow() != -1;
        this.editButton.setEnabled(rowSelected);
        this.defaultButton.setEnabled(rowSelected);
    }

    private void processOkButton() {
        this.colorsResult = this.colors;
        this.enabledResult = this.enabled;
        this.dialog.dispose();
    }

    private void processCancelButton() {
        this.dialog.dispose();
    }

    private void processEditButton() {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            return;
        }
        this.editRow(row);
    }

    private void editRow(int row) {
        Color newColor = JColorChooser.showDialog(this.dialog, "Choose Background Color", this.listener.getColorForRow(row));
        if (newColor != null) {
            this.listener.setColorForRow(row, newColor);
        }
    }

    private void processDefaultButton() {
        int[] rows = this.table.getSelectedRows();
        if (rows.length == 0) {
            return;
        }
        this.listener.changeToDefaults(rows);
    }

    private void processResetButton() {
        int[] rows = new int[this.table.getRowCount()];
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = i;
        }
        this.listener.changeToDefaults(rows);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CustomTableCellRenderer
    extends DefaultTableCellRenderer {
        private CustomTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int levelIndex = row + LogOutputWindow.levelToInt(Level.FINEST);
            c.setBackground(CustomizeDialog.this.colors[levelIndex]);
            return c;
        }
    }

    private class Listener
    extends AbstractTableModel
    implements WindowListener,
    ActionListener,
    ListSelectionListener,
    MouseListener {
        private Listener() {
        }

        public int getRowCount() {
            return LogOutputWindow.levelToInt(Level.SEVERE) + 1 - LogOutputWindow.levelToInt(Level.FINEST);
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Colorize";
                }
                case 1: {
                    return "Severity";
                }
                case 2: {
                    return "Sample Text";
                }
            }
            return null;
        }

        public Class getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return class$java$lang$Boolean == null ? (class$java$lang$Boolean = CustomizeDialog.class$("java.lang.Boolean")) : class$java$lang$Boolean;
                }
                case 1: {
                    return class$java$lang$String == null ? (class$java$lang$String = CustomizeDialog.class$("java.lang.String")) : class$java$lang$String;
                }
                case 2: {
                    return class$java$lang$String == null ? (class$java$lang$String = CustomizeDialog.class$("java.lang.String")) : class$java$lang$String;
                }
            }
            return null;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            int levelIndex = rowIndex + LogOutputWindow.levelToInt(Level.FINEST);
            switch (columnIndex) {
                case 0: {
                    return new Boolean(CustomizeDialog.this.enabled[levelIndex]);
                }
                case 1: {
                    return LogOutputWindow.intToName(levelIndex);
                }
                case 2: {
                    return "Sample text in the current color";
                }
            }
            return null;
        }

        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            int levelIndex = rowIndex + LogOutputWindow.levelToInt(Level.FINEST);
            switch (columnIndex) {
                case 0: {
                    CustomizeDialog.this.enabled[levelIndex] = (Boolean)value;
                }
            }
        }

        Color getColorForRow(int row) {
            int levelIndex = row + LogOutputWindow.levelToInt(Level.FINEST);
            return CustomizeDialog.this.colors[levelIndex];
        }

        void setColorForRow(int row, Color newColor) {
            int levelIndex = row + LogOutputWindow.levelToInt(Level.FINEST);
            CustomizeDialog.this.colors[levelIndex] = newColor;
            this.fireTableCellUpdated(row, 2);
        }

        void changeToDefaults(int[] rows) {
            for (int i = 0; i < rows.length; ++i) {
                int row = rows[i];
                int levelIndex = row + LogOutputWindow.levelToInt(Level.FINEST);
                CustomizeDialog.this.enabled[levelIndex] = CustomizeDialog.this.logOutputWindow.getDefaultEnablement(levelIndex);
                CustomizeDialog.this.colors[levelIndex] = CustomizeDialog.this.logOutputWindow.getDefaultBackground(levelIndex);
            }
            this.fireTableRowsUpdated(rows[0], rows[rows.length - 1]);
        }

        public void windowOpened(WindowEvent e) {
        }

        public void windowClosing(WindowEvent e) {
            CustomizeDialog.this.processCancelButton();
        }

        public void windowClosed(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowDeactivated(WindowEvent e) {
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == CustomizeDialog.this.okButton) {
                CustomizeDialog.this.processOkButton();
            } else if (source == CustomizeDialog.this.cancelButton) {
                CustomizeDialog.this.processCancelButton();
            } else if (source == CustomizeDialog.this.editButton) {
                CustomizeDialog.this.processEditButton();
            } else if (source == CustomizeDialog.this.defaultButton) {
                CustomizeDialog.this.processDefaultButton();
            } else if (source == CustomizeDialog.this.resetButton) {
                CustomizeDialog.this.processResetButton();
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            CustomizeDialog.this.enableControls();
        }

        public void mouseClicked(MouseEvent e) {
            int row;
            if (e.getButton() == 1 && e.getClickCount() == 2 && (row = CustomizeDialog.this.table.rowAtPoint(e.getPoint())) != -1) {
                CustomizeDialog.this.editRow(row);
            }
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }
}

